﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AP1_Cryptage_Digicode
{
    public partial class Interface_de_Cryptage : Form
    {
        public Interface_de_Cryptage()
        {
            InitializeComponent();
        }

        private void btCryptage_Click(object sender, EventArgs e)
        {
            // vérification si le mots de passe est plus grand ou plus petit 6 caractères
            if (tbACrypter.Text.Length > 6)
            {
                MessageBox.Show("Le mots de passe a crypter doit contenir 6 caractères");
            }
            else if (tbACrypter.Text.Length < 6)
            {
                MessageBox.Show("Le mots de passe a crypter doit contenir 6 caractères");
            }
            // si tout est bon on vérifie si le mots de passe saisie ne contient pas de chiffres
            else
            {
                if (tbACrypter.Text.Any(char.IsDigit))
                {
                    MessageBox.Show("Le mots de passe a crypter ne doit pas contenir de chiffres");
                }
                // vérifier qu'un RadioButton est coché
                else if (rbSalleInfo.Checked == false && rbEntreeBatiment.Checked == false)
                {
                    MessageBox.Show("Veuillez sélectionner Salle Info ou Entrée Bâtiment");
                }
                // vérifier qu'il n'y a bien qu'une diffusion par mois
                else
                {
                    // récupérer le mois et l'année actuels
                    DateTime dateActuelle = DateTime.Now;
                    int moisActuel = dateActuelle.Month;
                    int anneeActuelle = dateActuelle.Year;
                    bool existeDeja = false;

                    // déterminer le type qu'on veut créer
                    string type = "";
                    if (rbSalleInfo.Checked == true)
                    {
                        type = "I";

                    }
                    else
                    {
                        type = "E";
                    }

                    // lire le fichier secure.csv
                    StreamReader ligneFichierSecure = new StreamReader("digicod_secure.csv");
                    string ligneSecure;

                    // lecture de la ligne de titre
                    ligneSecure = ligneFichierSecure.ReadLine();

                    while ((ligneSecure = ligneFichierSecure.ReadLine()) != null && existeDeja == false)
                    {
                        string[] colonnes = ligneSecure.Split(';');

                        // vérifier qu'il y a bien assez de colonnes
                        if (colonnes.Length >= 4)
                        {
                            string typeAutorisation = colonnes[0];
                            string dateDebutFichier = colonnes[1];

                            // on ignore l'autorisation T car elle dure un an
                            if (typeAutorisation != "T")
                            {
                                // convertir la date en DateTime
                                DateTime date = Convert.ToDateTime(dateDebutFichier);

                                // vérifier si c'est le même mois, la même année ET le même type
                                if (date.Month == moisActuel && date.Year == anneeActuelle && typeAutorisation == type)
                                {
                                    existeDeja = true;
                                }
                            }
                        }
                    }

                    // fermer le fichier
                    ligneFichierSecure.Close();

                    // si le mois existe déjà
                    if (existeDeja == true)
                    {
                        MessageBox.Show("Un mot de passe existe déjà pour ce mois");
                    }
                    // si tout est bon on crypte
                    else
                    {
                        // récupérer le mot de passe et le mettre en majuscules
                        string motDePasse = tbACrypter.Text.ToUpper();
                        string motDePasseCrypte = "";



                        // crypter selon le RadioButton coché
                        if (rbSalleInfo.Checked == true)
                        {


                            // crypter pour la salle info I avec la formule 33 * a + 1 MOD 26
                            for (int i = 0; i < motDePasse.Length; i = i + 1)
                            {
                                char lettre = motDePasse[i];
                                int positionLettre = lettre - 'A';
                                int resultatCryptage = (33 * positionLettre + 1) % 26;
                                char lettreCryptee = (char)(resultatCryptage + 'A');
                                motDePasseCrypte = motDePasseCrypte + lettreCryptee;
                            }



                        }
                        else if (rbEntreeBatiment.Checked == true)
                        {


                            // crypter pour l'établissement E avec la formule a * 10 MOD 26
                            for (int i = 0; i < motDePasse.Length; i = i + 1)
                            {
                                char lettre = motDePasse[i];
                                int positionLettre = lettre - 'A';
                                int resultatCryptage = (positionLettre * 10) % 26;
                                char lettreCryptee = (char)(resultatCryptage + 'A');
                                motDePasseCrypte = motDePasseCrypte + lettreCryptee;
                            }
                        }

                        // afficher le résultat dans la TextBox
                        tbNewMdp.Text = motDePasseCrypte;

                        // enregistrer dans le fichier CSV
                        StreamWriter fichierSecure = new StreamWriter("digicod_secure.csv", true);



                        //if(existeDeja == True) 
                        //{
                        //  DateTime dateDebut = new DateTime(anneeActuelle, moisActuel+1, 01);
                        //  DateTime dateFin = new DateTime(anneeActuelle, moisActuel+1, DateTime.DaysInMonth(anneeActuelle, moisActuel+1));
                        //}
                        // else {}

                        // récupérer la date de début du mois
                        DateTime dateDebut = new DateTime(anneeActuelle, moisActuel, 01);

                        // récupérer la date de fin du mois
                        DateTime dateFin = new DateTime(anneeActuelle+12, moisActuel, DateTime.DaysInMonth(anneeActuelle, moisActuel)); //DaysInMonth permet d avoir le nombre de jour dans le mois par rapport a l'année actuel 

                        // écrire la ligne dans le fichier 
                        string ligne = type + ";" + dateDebut.ToShortDateString() + ";" + dateFin.ToShortDateString() + ";" + motDePasseCrypte;
                        fichierSecure.WriteLine(ligne);

                        // fermer le fichier
                        fichierSecure.Close();

                        MessageBox.Show("Cryptage réussi !");
                    }
                }
            }





        }

        private void btQuitter_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void Interface_de_Cryptage_Load(object sender, EventArgs e)
        {
            // récupérer la date actuelle
            DateTime dateActuelle = DateTime.Now;
            int moisActuel = dateActuelle.Month;
            int anneeActuelle = dateActuelle.Year;
            int jourActuel = dateActuelle.Day;

            // récupérer le dernier jour du mois
            int dernierJourDuMois = DateTime.DaysInMonth(anneeActuelle, moisActuel);

            // calculer le nombre de jours avant la fin du mois
            int joursRestants = dernierJourDuMois - jourActuel;

            //  il reste 3 jours ou moins
            if (joursRestants <= 3)
            {
                MessageBox.Show("Attention ! Il reste " + joursRestants + " jour(s) avant la fin du mois. Pensez à modifier les digicodes !");
            }
        }
    }
}


